!function(c){/**
    * @license
    * MIT License:
    *
    * Copyright (c) 2010-2013, Joe Walnes
    *               2013-2018, Drew Noakes
    *
    * Permission is hereby granted, free of charge, to any person obtaining a copy
    * of this software and associated documentation files (the "Software"), to deal
    * in the Software without restriction, including without limitation the rights
    * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    * copies of the Software, and to permit persons to whom the Software is
    * furnished to do so, subject to the following conditions:
    *
    * The above copyright notice and this permission notice shall be included in
    * all copies or substantial portions of the Software.
    *
    * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
    * THE SOFTWARE.
    */ /**
    * Smoothie Charts - http://smoothiecharts.org/
    * (c) 2010-2013, Joe Walnes
    *     2013-2018, Drew Noakes
    *
    * v1.0: Main charting library, by Joe Walnes
    * v1.1: Auto scaling of axis, by Neil Dunn
    * v1.2: fps (frames per second) option, by Mathias Petterson
    * v1.3: Fix for divide by zero, by Paul Nikitochkin
    * v1.4: Set minimum, top-scale padding, remove timeseries, add optional timer to reset bounds, by Kelley Reynolds
    * v1.5: Set default frames per second to 50... smoother.
    *       .start(), .stop() methods for conserving CPU, by Dmitry Vyal
    *       options.interpolation = 'bezier' or 'line', by Dmitry Vyal
    *       options.maxValue to fix scale, by Dmitry Vyal
    * v1.6: minValue/maxValue will always get converted to floats, by Przemek Matylla
    * v1.7: options.grid.fillStyle may be a transparent color, by Dmitry A. Shashkin
    *       Smooth rescaling, by Kostas Michalopoulos
    * v1.8: Set max length to customize number of live points in the dataset with options.maxDataSetLength, by Krishna Narni
    * v1.9: Display timestamps along the bottom, by Nick and Stev-io
    *       (https://groups.google.com/forum/?fromgroups#!topic/smoothie-charts/-Ywse8FCpKI%5B1-25%5D)
    *       Refactored by Krishna Narni, to support timestamp formatting function
    * v1.10: Switch to requestAnimationFrame, removed the now obsoleted options.fps, by Gergely Imreh
    * v1.11: options.grid.sharpLines option added, by @drewnoakes
    *        Addressed warning seen in Firefox when seriesOption.fillStyle undefined, by @drewnoakes
    * v1.12: Support for horizontalLines added, by @drewnoakes
    *        Support for yRangeFunction callback added, by @drewnoakes
    * v1.13: Fixed typo (#32), by @alnikitich
    * v1.14: Timer cleared when last TimeSeries removed (#23), by @davidgaleano
    *        Fixed diagonal line on chart at start/end of data stream, by @drewnoakes
    * v1.15: Support for npm package (#18), by @dominictarr
    *        Fixed broken removeTimeSeries function (#24) by @davidgaleano
    *        Minor performance and tidying, by @drewnoakes
    * v1.16: Bug fix introduced in v1.14 relating to timer creation/clearance (#23), by @drewnoakes
    *        TimeSeries.append now deals with out-of-order timestamps, and can merge duplicates, by @zacwitte (#12)
    *        Documentation and some local variable renaming for clarity, by @drewnoakes
    * v1.17: Allow control over font size (#10), by @drewnoakes
    *        Timestamp text won't overlap, by @drewnoakes
    * v1.18: Allow control of max/min label precision, by @drewnoakes
    *        Added 'borderVisible' chart option, by @drewnoakes
    *        Allow drawing series with fill but no stroke (line), by @drewnoakes
    * v1.19: Avoid unnecessary repaints, and fixed flicker in old browsers having multiple charts in document (#40), by @asbai
    * v1.20: Add SmoothieChart.getTimeSeriesOptions and SmoothieChart.bringToFront functions, by @drewnoakes
    * v1.21: Add 'step' interpolation mode, by @drewnoakes
    * v1.22: Add support for different pixel ratios. Also add optional y limit formatters, by @copacetic
    * v1.23: Fix bug introduced in v1.22 (#44), by @drewnoakes
    * v1.24: Fix bug introduced in v1.23, re-adding parseFloat to y-axis formatter defaults, by @siggy_sf
    * v1.25: Fix bug seen when adding a data point to TimeSeries which is older than the current data, by @Nking92
    *        Draw time labels on top of series, by @comolosabia
    *        Add TimeSeries.clear function, by @drewnoakes
    * v1.26: Add support for resizing on high device pixel ratio screens, by @copacetic
    * v1.27: Fix bug introduced in v1.26 for non whole number devicePixelRatio values, by @zmbush
    * v1.28: Add 'minValueScale' option, by @megawac
    *        Fix 'labelPos' for different size of 'minValueString' 'maxValueString', by @henryn
    * v1.29: Support responsive sizing, by @drewnoakes
    * v1.29.1: Include types in package, and make property optional, by @TrentHouliston
    * v1.30: Fix inverted logic in devicePixelRatio support, by @scanlime
    * v1.31: Support tooltips, by @Sly1024 and @drewnoakes
    * v1.32: Support frame rate limit, by @dpuyosa
    * v1.33: Use Date static method instead of instance, by @nnnoel
    *        Fix bug with tooltips when multiple charts on a page, by @jpmbiz70
    * v1.34: Add disabled option to TimeSeries, by @TechGuard (#91)
    *        Add nonRealtimeData option, by @annazhelt (#92, #93)
    *        Add showIntermediateLabels option, by @annazhelt (#94)
    *        Add displayDataFromPercentile option, by @annazhelt (#95)
    *        Fix bug when hiding tooltip element, by @ralphwetzel (#96)
    *        Support intermediate y-axis labels, by @beikeland (#99)
    * v1.35: Fix issue with responsive mode at high DPI, by @drewnoakes (#101)
    * v1.36: Add tooltipLabel to ITimeSeriesPresentationOptions.
    *        If tooltipLabel is present, tooltipLabel displays inside tooltip
    *        next to value, by @jackdesert (#102)
    *        Fix bug rendering issue in series fill when using scroll backwards, by @olssonfredrik
    *        Add title option, by @mesca
    *        Fix data drop stoppage by rejecting NaNs in append(), by @timdrysdale
    *        Allow setting interpolation per time series, by @WofWca (#123)
    *        Fix chart constantly jumping in 1-2 pixel steps, by @WofWca (#131)
    *        Fix a memory leak appearing when some `timeSeries.disabled === true`, by @WofWca (#132)
    *        Fix: make all lines sharp, remove the `grid.sharpLines` option by @WofWca (#134)
    *        Improve performance, by @WofWca (#135)
    *        Fix `this.delay` not being respected with `nonRealtimeData: true`, by @WofWca (#137)
    *        Fix series fill & stroke being inconsistent for last data time < render time, by @WofWca (#138)
    * v1.36.1: Fix a potential XSS when `tooltipLabel` or `strokeStyle` are controlled by users, by @WofWca
    */ a,Date.now=Date.now||function(){return new Date().getTime()};var d={extend:function(){arguments[0]=arguments[0]||{};for(var b=1;b<arguments.length;b++)for(var a in arguments[b])arguments[b].hasOwnProperty(a)&&("object"==typeof arguments[b][a]?arguments[b][a]instanceof Array?arguments[0][a]=arguments[b][a]:arguments[0][a]=d.extend(arguments[0][a],arguments[b][a]):arguments[0][a]=arguments[b][a]);return arguments[0]},binarySearch:function(d,e){for(var a=0,b=d.length;a<b;){var c=a+b>>1;e<d[c][0]?b=c:a=c+1}return a},pixelSnap:function(a,b){return b%2==0?Math.round(a):Math.floor(a)+.5}};function b(a){this.options=d.extend({},b.defaultOptions,a),this.disabled=!1,this.clear()}function a(b){this.options=d.extend({},a.defaultChartOptions,b),this.seriesSet=[],this.currentValueRange=1,this.currentVisMinValue=0,this.lastRenderTimeMillis=0,this.lastChartTimestamp=0,this.mousemove=this.mousemove.bind(this),this.mouseout=this.mouseout.bind(this)}b.defaultOptions={resetBoundsInterval:3e3,resetBounds:!0},b.prototype.clear=function(){this.data=[],this.maxValue=Number.NaN,this.minValue=Number.NaN},b.prototype.resetBounds=function(){if(this.data.length){this.maxValue=this.data[0][1],this.minValue=this.data[0][1];for(var b=1;b<this.data.length;b++){var a=this.data[b][1];a>this.maxValue&&(this.maxValue=a),a<this.minValue&&(this.minValue=a)}}else this.maxValue=Number.NaN,this.minValue=Number.NaN},b.prototype.append=function(b,a,f){if(!(isNaN(b)||isNaN(a))){var e=this.data.length-1;if(e>=0)for(var d=e;;){var c=this.data[d];if(b>=c[0]){b===c[0]?f?(c[1]+=a,a=c[1]):c[1]=a:this.data.splice(d+1,0,[b,a]);break}if(--d<0){this.data.splice(0,0,[b,a]);break}}else this.data.push([b,a]);this.maxValue=isNaN(this.maxValue)?a:Math.max(this.maxValue,a),this.minValue=isNaN(this.minValue)?a:Math.min(this.minValue,a)}},b.prototype.dropOldData=function(b,c){for(var a=0;this.data.length-a>=c&&this.data[a+1][0]<b;)a++;0!==a&&this.data.splice(0,a)},a.tooltipFormatter=function(g,c){var e,h=this.options.timestampFormatter||a.timeFormatter,d=document.createElement("div");d.appendChild(document.createTextNode(h(new Date(g))));for(var b=0;b<c.length;++b){""!==(e=c[b].series.options.tooltipLabel||"")&&(e+=" ");var f=document.createElement("span");f.style.color=c[b].series.options.strokeStyle,f.appendChild(document.createTextNode(e+this.options.yMaxFormatter(c[b].value,this.options.labels.precision))),d.appendChild(document.createElement("br")),d.appendChild(f)}return d.innerHTML},a.defaultChartOptions={millisPerPixel:20,enableDpiScaling:!0,yMinFormatter:function(a,b){return parseFloat(a).toFixed(b)},yMaxFormatter:function(a,b){return parseFloat(a).toFixed(b)},yIntermediateFormatter:function(a,b){return parseFloat(a).toFixed(b)},maxValueScale:1,minValueScale:1,interpolation:"bezier",scaleSmoothing:.125,maxDataSetLength:2,scrollBackwards:!1,displayDataFromPercentile:1,grid:{fillStyle:"#000000",strokeStyle:"#777777",lineWidth:2,millisPerLine:1e3,verticalSections:2,borderVisible:!0},labels:{fillStyle:"#ffffff",disabled:!1,fontSize:10,fontFamily:"monospace",precision:2,showIntermediateLabels:!1,intermediateLabelSameAxis:!0},title:{text:"",fillStyle:"#ffffff",fontSize:15,fontFamily:"monospace",verticalAlign:"middle"},horizontalLines:[],tooltip:!1,tooltipLine:{lineWidth:1,strokeStyle:"#BBBBBB"},tooltipFormatter:a.tooltipFormatter,nonRealtimeData:!1,responsive:!1,limitFPS:0},a.AnimateCompatibility={requestAnimationFrame:function(a,b){return(window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(a){return window.setTimeout(function(){a(Date.now())},16)}).call(window,a,b)},cancelAnimationFrame:function(a){return(window.cancelAnimationFrame||function(a){clearTimeout(a)}).call(window,a)}},a.defaultSeriesPresentationOptions={lineWidth:1,strokeStyle:"#ffffff"},a.prototype.addTimeSeries=function(b,c){this.seriesSet.push({timeSeries:b,options:d.extend({},a.defaultSeriesPresentationOptions,c)}),b.options.resetBounds&&b.options.resetBoundsInterval>0&&(b.resetBoundsTimerId=setInterval(function(){b.resetBounds()},b.options.resetBoundsInterval))},a.prototype.removeTimeSeries=function(b){for(var c=this.seriesSet.length,a=0;a<c;a++)if(this.seriesSet[a].timeSeries===b){this.seriesSet.splice(a,1);break}b.resetBoundsTimerId&&clearInterval(b.resetBoundsTimerId)},a.prototype.getTimeSeriesOptions=function(b){for(var c=this.seriesSet.length,a=0;a<c;a++)if(this.seriesSet[a].timeSeries===b)return this.seriesSet[a].options},a.prototype.bringToFront=function(b){for(var c=this.seriesSet.length,a=0;a<c;a++)if(this.seriesSet[a].timeSeries===b){var d=this.seriesSet.splice(a,1);this.seriesSet.push(d[0]);break}},a.prototype.streamTo=function(a,b){this.canvas=a,this.clientWidth=parseInt(this.canvas.getAttribute("width")),this.clientHeight=parseInt(this.canvas.getAttribute("height")),this.delay=b,this.start()},a.prototype.getTooltipEl=function(){return this.tooltipEl||(this.tooltipEl=document.createElement("div"),this.tooltipEl.className="smoothie-chart-tooltip",this.tooltipEl.style.pointerEvents="none",this.tooltipEl.style.position="absolute",this.tooltipEl.style.display="none",document.body.appendChild(this.tooltipEl)),this.tooltipEl},a.prototype.updateTooltip=function(){if(this.options.tooltip){var a=this.getTooltipEl();if(!this.mouseover||!this.options.tooltip){a.style.display="none";return}for(var g=this.lastChartTimestamp,h=this.options.scrollBackwards?g-this.mouseX*this.options.millisPerPixel:g-(this.clientWidth-this.mouseX)*this.options.millisPerPixel,f=[],b=0;b<this.seriesSet.length;b++){var c=this.seriesSet[b].timeSeries;if(!c.disabled){var e=d.binarySearch(c.data,h);e>0&&e<c.data.length&&f.push({series:this.seriesSet[b],index:e,value:c.data[e][1]})}}f.length?(a.innerHTML=this.options.tooltipFormatter.call(this,h,f),a.style.display="block"):a.style.display="none"}},a.prototype.mousemove=function(a){if(this.mouseover=!0,this.mouseX=a.offsetX,this.mouseY=a.offsetY,this.mousePageX=a.pageX,this.mousePageY=a.pageY,this.options.tooltip){var b=this.getTooltipEl();b.style.top=Math.round(this.mousePageY)+"px",b.style.left=Math.round(this.mousePageX)+"px",this.updateTooltip()}},a.prototype.mouseout=function(){this.mouseover=!1,this.mouseX=this.mouseY=-1,this.tooltipEl&&(this.tooltipEl.style.display="none")},a.prototype.resize=function(){var b,c,a=this.options.enableDpiScaling&&window?window.devicePixelRatio:1;this.options.responsive?(b=this.canvas.offsetWidth,c=this.canvas.offsetHeight,b!==this.lastWidth&&(this.lastWidth=b,this.canvas.setAttribute("width",Math.floor(b*a).toString()),this.canvas.getContext("2d").scale(a,a)),c!==this.lastHeight&&(this.lastHeight=c,this.canvas.setAttribute("height",Math.floor(c*a).toString()),this.canvas.getContext("2d").scale(a,a)),this.clientWidth=b,this.clientHeight=c):(b=parseInt(this.canvas.getAttribute("width")),c=parseInt(this.canvas.getAttribute("height")),1!==a?(Math.floor(this.clientWidth*a)!==b&&(this.canvas.setAttribute("width",Math.floor(b*a).toString()),this.canvas.style.width=b+"px",this.clientWidth=b,this.canvas.getContext("2d").scale(a,a)),Math.floor(this.clientHeight*a)!==c&&(this.canvas.setAttribute("height",Math.floor(c*a).toString()),this.canvas.style.height=c+"px",this.clientHeight=c,this.canvas.getContext("2d").scale(a,a))):(this.clientWidth=b,this.clientHeight=c))},a.prototype.start=function(){if(!this.frame){this.canvas.addEventListener("mousemove",this.mousemove),this.canvas.addEventListener("mouseout",this.mouseout);var b=(function(){this.frame=a.AnimateCompatibility.requestAnimationFrame((function(){if(this.options.nonRealtimeData){var a=new Date(0),c=this.seriesSet.reduce((function(c,e){var a=e.timeSeries.data,b=Math.round(this.options.displayDataFromPercentile*a.length)-1;if(b=(b=b>=0?b:0)<=a.length-1?b:a.length-1,a&&a.length>0){var d=a[b][0];c=c>d?c:d}return c}).bind(this),a);this.render(this.canvas,c>a?c:null)}else this.render();b()}).bind(this))}).bind(this);b()}},a.prototype.stop=function(){this.frame&&(a.AnimateCompatibility.cancelAnimationFrame(this.frame),delete this.frame,this.canvas.removeEventListener("mousemove",this.mousemove),this.canvas.removeEventListener("mouseout",this.mouseout))},a.prototype.updateValueRange=function(){for(var c=this.options,b=Number.NaN,a=Number.NaN,e=0;e<this.seriesSet.length;e++){var d=this.seriesSet[e].timeSeries;!d.disabled&&(isNaN(d.maxValue)||(b=isNaN(b)?d.maxValue:Math.max(b,d.maxValue)),isNaN(d.minValue)||(a=isNaN(a)?d.minValue:Math.min(a,d.minValue)))}if(null!=c.maxValue?b=c.maxValue:b*=c.maxValueScale,null!=c.minValue?a=c.minValue:a-=Math.abs(a*c.minValueScale-a),this.options.yRangeFunction){var f=this.options.yRangeFunction({min:a,max:b});a=f.min,b=f.max}if(!isNaN(b)&&!isNaN(a)){var g=b-a-this.currentValueRange,h=a-this.currentVisMinValue;this.isAnimatingScale=Math.abs(g)>.1||Math.abs(h)>.1,this.currentValueRange+=c.scaleSmoothing*g,this.currentVisMinValue+=c.scaleSmoothing*h}this.valueRange={min:a,max:b}},a.prototype.render=function(F,e){var m=Date.now();if(!(this.options.limitFPS>0)||!(m-this.lastRenderTimeMillis<1e3/this.options.limitFPS)){if(e=(e||m)-(this.delay||0),e-=e%this.options.millisPerPixel,!this.isAnimatingScale&&this.lastChartTimestamp===e&&!(m-this.lastRenderTimeMillis>1e3/6))return;this.lastRenderTimeMillis=m,this.lastChartTimestamp=e,this.resize();var a=(F=F||this.canvas).getContext("2d"),b=this.options,c={top:0,left:0,width:this.clientWidth,height:this.clientHeight},s=e-c.width*b.millisPerPixel,t=(function(a,b){var e=a-this.currentVisMinValue,f=0===this.currentValueRange?c.height:c.height*(1-e/this.currentValueRange);return d.pixelSnap(f,b)}).bind(this),n=function(a,f){var g=b.scrollBackwards?(e-a)/b.millisPerPixel:c.width-(e-a)/b.millisPerPixel;return d.pixelSnap(g,f)};if(this.updateValueRange(),a.font=b.labels.fontSize+"px "+b.labels.fontFamily,a.save(),a.translate(c.left,c.top),a.beginPath(),a.rect(0,0,c.width,c.height),a.clip(),a.save(),a.fillStyle=b.grid.fillStyle,a.clearRect(0,0,c.width,c.height),a.fillRect(0,0,c.width,c.height),a.restore(),a.save(),a.lineWidth=b.grid.lineWidth,a.strokeStyle=b.grid.strokeStyle,b.grid.millisPerLine>0){a.beginPath();for(var g=e-e%b.grid.millisPerLine;g>=s;g-=b.grid.millisPerLine){var f=n(g,b.grid.lineWidth);a.moveTo(f,0),a.lineTo(f,c.height)}a.stroke(),a.closePath()}for(var h=1;h<b.grid.verticalSections;h++){var o=d.pixelSnap(h*c.height/b.grid.verticalSections,b.grid.lineWidth);a.beginPath(),a.moveTo(0,o),a.lineTo(c.width,o),a.stroke(),a.closePath()}if(b.grid.borderVisible&&(a.beginPath(),a.strokeRect(0,0,c.width,c.height),a.closePath()),a.restore(),b.horizontalLines&&b.horizontalLines.length)for(var u=0;u<b.horizontalLines.length;u++){var v=b.horizontalLines[u],G=v.lineWidth||1,H=t(v.value,G);a.strokeStyle=v.color||"#ffffff",a.lineWidth=G,a.beginPath(),a.moveTo(0,H),a.lineTo(c.width,H),a.stroke(),a.closePath()}for(var p=0;p<this.seriesSet.length;p++){var w=this.seriesSet[p].timeSeries,l=w.data;if(w.dropOldData(s,b.maxDataSetLength),!(l.length<=1)&&!w.disabled){a.save();var i=this.seriesSet[p].options,I=i.strokeStyle&&"none"!==i.strokeStyle,k=I?i.lineWidth:0;a.beginPath();var q,x=n(l[0][0],k),J=t(l[0][1],k),y=x,K=J;switch(a.moveTo(x,J),i.interpolation||b.interpolation){case"linear":case"line":q=function(b,c,d,e){a.lineTo(b,c)};break;case"bezier":default:q=function(b,c,d,e){a.bezierCurveTo(Math.round((d+b)/2),e,Math.round(d+b)/2,c,b,c)};break;case"step":q=function(b,c,e,d){a.lineTo(b,d),a.lineTo(b,c)}}for(var z=1;z<l.length;z++){var L=l[z],M=n(L[0],k),N=t(L[1],k);q(M,N,y,K),y=M,K=N}I&&(a.lineWidth=i.lineWidth,a.strokeStyle=i.strokeStyle,a.stroke()),i.fillStyle&&(a.lineTo(y,c.height+k+1),a.lineTo(x,c.height+k+1),a.fillStyle=i.fillStyle,a.fill()),a.restore()}}b.tooltip&&this.mouseX>=0&&(a.lineWidth=b.tooltipLine.lineWidth,a.strokeStyle=b.tooltipLine.strokeStyle,a.beginPath(),a.moveTo(this.mouseX,0),a.lineTo(this.mouseX,c.height),a.closePath(),a.stroke()),this.updateTooltip();var j=b.labels;if(!j.disabled&&!isNaN(this.valueRange.min)&&!isNaN(this.valueRange.max)){var O=b.yMaxFormatter(this.valueRange.max,j.precision),r=b.yMinFormatter(this.valueRange.min,j.precision),P=b.scrollBackwards?0:c.width-a.measureText(O).width-2,Q=b.scrollBackwards?0:c.width-a.measureText(r).width-2;a.fillStyle=j.fillStyle,a.fillText(O,P,j.fontSize),a.fillText(r,Q,c.height-2)}if(j.showIntermediateLabels&&!isNaN(this.valueRange.min)&&!isNaN(this.valueRange.max)&&b.grid.verticalSections>0)for(var R=(this.valueRange.max-this.valueRange.min)/b.grid.verticalSections,S=c.height/b.grid.verticalSections,h=1;h<b.grid.verticalSections;h++){var o=c.height-Math.round(h*S),A=b.yIntermediateFormatter(this.valueRange.min+h*R,j.precision),T=j.intermediateLabelSameAxis?b.scrollBackwards?0:c.width-a.measureText(A).width-2:b.scrollBackwards?c.width-a.measureText(A).width-2:0;a.fillText(A,T,o-b.grid.lineWidth)}if(b.timestampFormatter&&b.grid.millisPerLine>0)for(var B=b.scrollBackwards?a.measureText(r).width:c.width-a.measureText(r).width+4,g=e-e%b.grid.millisPerLine;g>=s;g-=b.grid.millisPerLine){var f=n(g,0);if(!b.scrollBackwards&&f<B||b.scrollBackwards&&f>B){var U=new Date(g),C=b.timestampFormatter(U),D=a.measureText(C).width;B=b.scrollBackwards?f+D+2:f-D-2,a.fillStyle=b.labels.fillStyle,b.scrollBackwards?a.fillText(C,f,c.height-2):a.fillText(C,f-D,c.height-2)}}if(""!==b.title.text){a.font=b.title.fontSize+"px "+b.title.fontFamily;var V=b.scrollBackwards?c.width-a.measureText(b.title.text).width-2:2;if("bottom"==b.title.verticalAlign){a.textBaseline="bottom";var E=c.height}else if("middle"==b.title.verticalAlign){a.textBaseline="middle";var E=c.height/2}else{a.textBaseline="top";var E=0}a.fillStyle=b.title.fillStyle,a.fillText(b.title.text,V,E)}a.restore()}},a.timeFormatter=function(a){function b(a){return(a<10?"0":"")+a}return b(a.getHours())+":"+b(a.getMinutes())+":"+b(a.getSeconds())},c.TimeSeries=b,c.SmoothieChart=a}("undefined"==typeof exports?this:exports)